<?php

namespace Drupal\recite_me\Plugin\Block;

use Drupal\Core\Block\BlockBase;

/**
 * Provides a ReciteMe Embed Block.
 *
 * @Block(
 *   id = "recite_me_block",
 *   admin_label = @Translation("ReciteMe Accessibility Tool"),
 *   category = @Translation("Accessibility"),
 * )
 */
class ReciteMeBlock extends BlockBase
{
    /**
    * {@inheritdoc}
    */
    public function build()
    {
        $config = \Drupal::config('recite_me.settings');
        return [
            '#theme' => 'recite_me',
            '#token' => $config->get('token'),
            '#options' => $config->get('options'),
            '#loaded_code' => $config->get('loaded_code'),
            '#preload_code' => $config->get('preload_code'),
            '#floating_button' => $config->get('floating_button'),
        ];
    }
}
