<?php

namespace Drupal\recite_me\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

class ReciteMeForm extends ConfigFormBase
{
    /**
    * {@inheritdoc}
    */
    public function getFormId()
    {
        return 'recite_me_form';
    }

    /**
    * {@inheritdoc}
    */
    public function buildForm(array $form, FormStateInterface $form_state)
    {
        $form = parent::buildForm($form, $form_state);
        $config = $this->config('recite_me.settings');

        $form['token'] = [
            '#type' => 'textfield',
            '#title' => $this->t('ReciteMe Client Key:'),
            '#default_value' => $config->get('token'),
            '#description' => $this->t('Enter your ReciteMe Client Key here.'),
        ];

        $form['options'] = [
            '#type' => 'textarea',
            '#title' => $this->t('ReciteMe Options:'),
            '#default_value' => $config->get('options'),
            '#description' => $this->t('Enter any custom options code here.'),
        ];

        $form['loaded_code'] = [
            '#type' => 'textarea',
            '#title' => $this->t('ReciteMe Loaded Code:'),
            '#default_value' => $config->get('loaded_code'),
            '#description' => $this->t('Enter any additional Loaded Code here.'),
        ];

        $form['preload_code'] = [
            '#type' => 'textarea',
            '#title' => $this->t('ReciteMe Preload Code:'),
            '#default_value' => $config->get('preload_code'),
            '#description' => $this->t('Enter any additional Preload Code here.'),
        ];

        $form['floating_button'] = [
            '#type' => 'radios',
            '#title' => $this->t('ReciteMe enable floating button:'),
            '#default_value' => $config->get('floating_button'),
            '#description' => $this->t('Enable or disable the floating button.'),
            '#options' => array( true => 'Yes', false => 'No'),       
 ];

        return $form;
    }

    /**
    * {@inheritdoc}
    */
    public function validateForm(array &$form, FormStateInterface $form_state) {

    }

    /**
    * {@inheritdoc}
    */
    public function submitForm(array &$form, FormStateInterface $form_state) {
        $config = $this->config('recite_me.settings');
        $config->set('token', $form_state->getValue('token'));
        $config->set('options', $form_state->getValue('options'));
        $config->set('loaded_code', $form_state->getValue('loaded_code'));
        $config->set('preload_code', $form_state->getValue('preload_code'));
        $config->set('floating_button', $form_state->getValue('floating_button'));
        $config->save();
        return parent::submitForm($form, $form_state);
    }

    /**
    * {@inheritdoc}
    */
    protected function getEditableConfigNames() {
        return [
            'recite_me.settings',
        ];
    }
}
