<?php
/*
Plugin Name: ReciteMe Plugin
Plugin URI: http://reciteme.com
Description: Adds support for the ReciteMe Toolbar.
Author: Craig Tyers, Richard Nicholson
Author URI: http://reciteme.com/
Version: 2.3.9
Text Domain: ReciteMe
*/

defined('ABSPATH') or die('No script kiddies please!');

$configKey = 'reciteMe_';
$isPost = $_SERVER['REQUEST_METHOD'] === 'POST';

// Create Admin Page:
add_action("admin_menu", "reciteMeAdminMenu");

/**
 * Adds a menu item for recite me to the settings menu and set the function to call for that page to be 'reciteMeSettings'.
 */
function reciteMeAdminMenu()
{
    add_options_page("reciteMe Settings", "Recite Me", "manage_options", "reciteMeSettings", "reciteMeSettings");
}

function reciteGetCodeOption($key, $default = false)
{
    return wp_unslash(get_option($key, $default));
}

function reciteSetCodeOption($key, $value)
{
    add_option($key, $value);
    update_option($key, $value);
}

function isReciteRegion($key)
{
    global $configKey;
    $region = reciteGetCodeOption($configKey . "region", "uk");
    if (strcasecmp($region, $key) == 0) {
        return " selected=\"selected\" ";
    }
    return "";
}
function isReciteFloatingPosition($key)
{
    global $configKey;
    $position = reciteGetfloatongPositionOption($configKey . "floating_button_position", "bottom-right");
    if (strcasecmp($position, $key) == 0) {
        return " selected=\"selected\" ";
    }
    return "";
}
function reciteGetfloatongPositionOption($key, $default = false)
{
    return wp_unslash(get_option($key, $default));
}
/**
 * Function to provide the form and update options for all recite me settings.
 */
function reciteMeSettings()
{
    global $configKey, $isPost;

    // Check Permissions:
    if (!current_user_can('manage_options')) {
        wp_die("You do not have access to this section - sorry.");
    }

    $reciteKey = get_option($configKey . 'key');
    $autoLaunch = get_option($configKey . 'launch_auto');
    $launchSelector = get_option($configKey . 'launch_class');
    $additionalOptions = reciteGetCodeOption($configKey . "additional_options");
    $loadedCode = reciteGetCodeOption($configKey . "loaded_code");
    $floatingButton = reciteGetCodeOption($configKey . "floating_button");
    $preloadCode = reciteGetCodeOption($configKey . "preload_code");
    $region = reciteGetCodeOption($configKey . "region", "uk");
    $floatingButtonPosition = reciteGetCodeOption($configKey . "floating_button_position", "bottom-right");


    $default_tab = null;
    $tab = isset($_GET['tab']) ? $_GET['tab'] : $default_tab;
    // Update Settings from POST:
    if ($isPost) {
        $autoLaunchPost = isset($_POST[$configKey . 'launch_auto']);
        $launchSelectorPost = $_POST[$configKey . 'launch_class'];
        $additionalOptionsPost = wp_unslash($_POST[$configKey . 'additional_options']);
        $loadedCodePost = wp_unslash($_POST[$configKey . 'loaded_code']);
        $floatingButtonPost = wp_unslash($_POST[$configKey . 'floating_button']);
        $preloadCodePost = wp_unslash($_POST[$configKey . 'preload_code']);
        $regionPost = wp_unslash($_POST[$configKey . 'region']);
        $floatingButtonPositionPost = wp_unslash($_POST[$configKey . 'floating_button_position']);
        // Client Key:
        if (isset($_POST[$configKey . 'key'])) {
            if (empty($_POST[$configKey . 'key'])) {
                echo "<div class=\"notice notice-error is-dismissible\"><p>Your recite me key should not be empty</p></div>";
            }
            // TODO: We could possibly do a curl to check the validity of the key at this point...
            elseif ($_POST[$configKey . 'key'] != $reciteKey) {
                add_option($configKey . 'key', $_POST[$configKey . 'key']);
                update_option($configKey . 'key', $_POST[$configKey . 'key']);
                $reciteKey = get_option($configKey . 'key');
                echo "<div class=\"updated notice notice-success is-dismissible\"><p>Your recite me key has been updated to : '" . $reciteKey . "'</p></div>";
            }
        }


        // Region Selector:
        if (isset($_POST[$configKey . 'region'])) {
            if ($regionPost != $region) {
                add_option($configKey . 'region', $regionPost);
                update_option($configKey . 'region', $regionPost);
                $region = get_option($configKey . 'region');
                echo "<div class=\"updated notice notice-success is-dismissible\"><p>Recite Region is set to $region.</p></div>";
            }
        }

        if (isset($_POST[$configKey . 'floating_button_position'])) {
            if ($floatingButtonPositionPost != $floatingButtonPosition) {
                add_option($configKey . 'floating_button_position', $floatingButtonPositionPost);
                update_option($configKey . 'floating_button_position', $floatingButtonPositionPost);
                $floatingButtonPosition = get_option($configKey . 'floating_button_position');
                echo "<div class=\"updated notice notice-success is-dismissible\"><p>Recite Floating Button Position is set to $floatingButtonPosition.</p></div>";
            }
        }

        // Auto Start:
        //cant check this one as if its set to off it will just be not in post! 
        if ($tab != "advanced" && $autoLaunchPost != $autoLaunch) {
            add_option($configKey . 'launch_auto', $autoLaunchPost);
            update_option($configKey . 'launch_auto', $autoLaunchPost);
            $autoLaunch = get_option($configKey . 'launch_auto');
            if ($autoLaunch) {
                echo "<div class=\"updated notice notice-success is-dismissible\"><p>Recite is set to start up automatically.</p></div>";
            } else {
                echo "<div class=\"updated notice notice-warning is-dismissible\"><p>Recite is set to NOT start up automatically.</p></div>";
            }
        }

        // Launch Selector:
        if (isset($_POST[$configKey . 'launch_class'])) {
            if ($launchSelectorPost != $launchSelector) {
                add_option($configKey . 'launch_class', $launchSelectorPost);
                update_option($configKey . 'launch_class', $launchSelectorPost);
                $launchSelector = get_option($configKey . 'launch_class');
                echo "<div class=\"updated notice notice-success is-dismissible\"><p>Recite launch class is set to $launchSelector.</p></div>";
            }
        }

        // Floating Button:
        //cant check this one as if its set to off it will just be not in post! 
        if ($tab != "advanced" && $floatingButtonPost != $floatingButton) {
            add_option($configKey . 'floating_button', $floatingButtonPost);
            update_option($configKey . 'floating_button', $floatingButtonPost);
            $floatingButton = get_option($configKey . 'floating_button');
            if ($floatingButton) {
                echo "<div class=\"updated notice notice-success is-dismissible\"><p>Floating Button Enabled.</p></div>";
            } else {
                echo "<div class=\"updated notice notice-warning is-dismissible\"><p>Floating Button Disabled</p></div>";
            }
        }

        // Additional Options:
        if (isset($_POST[$configKey . 'additional_options'])) {
            if ($additionalOptionsPost != $additionalOptions) {
                reciteSetCodeOption($configKey . 'additional_options', $additionalOptionsPost);
                $additionalOptions = reciteGetCodeOption($configKey . 'additional_options');
                echo '<div class="updated notice notice-success is-dismissible"><p>ReciteMe Options updated.</p></div>';
            }
        }

        // Loaded Code:
        if (isset($_POST[$configKey . 'loaded_code'])) {
            if ($loadedCodePost != $loadedCode) {
                reciteSetCodeOption($configKey . 'loaded_code', $loadedCodePost);
                $loadedCode = reciteGetCodeOption($configKey . 'loaded_code');
                echo '<div class="updated notice notice-success is-dismissible"><p>ReciteMe Loaded Code updated.</p></div>';
            }
        }

        // Preload Code:
        if (isset($_POST[$configKey . 'preload_code'])) {
            if ($preloadCodePost != $preloadCode) {
                reciteSetCodeOption($configKey . 'preload_code', $preloadCodePost);
                $preloadCode = reciteGetCodeOption($configKey . 'preload_code');
                echo '<div class="updated notice notice-success is-dismissible"><p>ReciteMe Preload Code updated.</p></div>';
            }
        }
    }

    $default_tab = null;
    $tab = isset($_GET['tab']) ? $_GET['tab'] : $default_tab;
    $position = get_option('floating_button_position', 'bottom-right');
    $floatingButtonOptions = [
        'bottom-left' => 'Bottom Left',
        'bottom-right' => 'Bottom Right',
        'middle-left' => 'Middle Left',
        'middle-right' => 'Middle Right',
        'top-left' => 'Top Left',
        'top-right' => 'Top Right',
    ];
    ?>

    <h1>Recite Me Settings</h1>

    <nav class="nav-tab-wrapper">
        <a href="?page=reciteMeSettings" class="nav-tab <?php if ($tab === null) : ?>nav-tab-active<?php endif; ?>">ReciteMe settings</a>
        <a href="?page=reciteMeSettings&tab=advanced" class="nav-tab <?php if ($tab === 'advanced') : ?>nav-tab-active<?php endif; ?>">Advanced Options</a>
    </nav>

    <div class="tab-content">

        <?php
            if ($tab != "advanced") {
                ?>
            <h4>Basic Settings</h4>
            <p>From here you can manage your ReciteMe Toolbar.</p>
        <?php
            } else {
                ?>
            <h4>Advanced Options</h4>
            <p>
                In Most cases you will not need to add anything to the options below this point.
                <br />You should only do so when advised to, by ReciteMe support
            </p>
        <?php
            }
    ?>

        <form method='post'>
            <table class='form-table'>
                <tbody>

                    <?php

                if ($tab != "advanced") { ?>



                        <tr>
                            <th scope='row'>
                                <label for='<?= $configKey ?>key'>ReciteMe Client Key:</label>
                            </th>
                            <td>
                                <input type='text' name='<?= $configKey ?>key' id='<= $configKey ?>key' class='regular-text' value='<?= $reciteKey ?>' placeholder='Please enter your ReciteMe Client Key.' />
                                <p>
                                    ReciteMe will supply you with your unique client key.
                                    <br />you must enter that here for your ReciteMe toolbar to work.
                                </p>
                            </td>
                        </tr>

                        <tr>
                            <th scope='row'>
                                <label for='<?= $configKey ?>region'>ReciteMe Client Region:</label>
                            </th>
                            <td>
                                <select class='regular-text' name='<?= $configKey ?>region' id='<= $configKey ?>region'>
                                    <option value="uk" <?php echo  isReciteRegion("uk")  ?>>UK</option>
                                    <option value="us" <?php echo  isReciteRegion("us")  ?>>USA</option>
                                    <option value="au" <?php echo  isReciteRegion("au")  ?>>Australia</option>
                                </select>
                                <p>
                                    You should select UK.</b>
                                    <br /><i>Unless</i> you have been told you select anywhere else by ReciteMe support.
                                </p>
                            </td>
                        </tr>


                        <tr>
                            <th scope='row'>
                                <label for='<?= $configKey ?>launch_auto'>Launch Toolbar Automatically:</label>
                            </th>
                            <td>
                                <input type='checkbox' name='<?= $configKey ?>launch_auto' id='<?= $configKey ?>launch_auto' <?= ($autoLaunch ? "checked='checked'" : ""); ?> />
                                <p>Checking this box will cause the toolbar to launch automatically on every page.
                                    <br />If you un-check this box then the toolbar will only launch with a link click (set that up below)
                                </p>
                            </td>
                        </tr>

                        <tr>
                            <th scope='row'>
                                <label for='<?= $configKey ?>floating_button'>Use a floating button:</label>
                            </th>
                            <td>
                                <input type='checkbox' name='<?= $configKey ?>floating_button' id='<?= $configKey ?>floating_button' <?= ($floatingButton ? "checked='checked'" : ""); ?> />
                                <p>Checking this box will add a floating button
                                </p>
                            </td>
                        </tr>
                
                        <tr>
                            <th scope='row'>
                                <label for='<?= $configKey ?>floating_button_position'>Floating button Position:</label>
                            </th>
                            <td>
                            <select name='<?= $configKey ?>floating_button_position' id='<?= $configKey ?>floating_button_position'>
                                <?php foreach ($floatingButtonOptions as $key => $label) {
                                    $selected = isReciteFloatingPosition($key) ;
                                    echo "<option value='$key' $selected>$label</option>";
                                }     ?> 
                            </select>
                                <p>
                                    Choose the position of the floating button.
                                    <br />This will only be used if you have enabled the floating button above.
                                </p>   
                            </td>
                        </tr>


                        <tr>
                            <th scope='row'>
                                <label for='<?= $configKey ?>launch_class'>Launch Button Selector:</label>

                            </th>
                            <td>
                                <input type='text' name='<?= $configKey ?>launch_class' id='<?= $configKey ?>launch_class' class='regular-text' value='<?= stripslashes($launchSelector) ?>' placeholder='[href$="#reciteme"]' />
                                <p>This is used to find any Toolbar Launch Buttons/Links.</p>
                                <p>This can be a class (.class_name) or identifier (#id) or data attribute ([attribute='value']) and can take multiple values comma seperated.</p>
                                <p>
                                    <Strong>To add a link into your menus that will launch ReciteMe:</Strong>
                                <ol>
                                    <li>Leave the above box empty so that it defaults to <strong>[href$="#reciteme"]</strong></li>
                                    <li>Go to <a href="<?php echo admin_url() ?>nav-menus.php">Appearance&gt;Menus</a></li>
                                    <li>Select the menu where you want to show your ReciteMe toolbar lanuching link</li>
                                    <li>Choose 'custom links'</li>
                                    <li>Enter the URL as <strong>#reciteme</strong></li>
                                    <li>At 'link text', enter the text you wish your visitors to see <br />(for exampe 'Accessibility tools')</li>
                                    <li>Click 'add to menu' and then 'save menu'.</li>
                                </ol>
                                </p>

                            </td>
                        </tr>


                    <?php
                } //close tab if
                else {

                    ?>

                        <tr>
                            <th scope='row'>
                                <label for='<?= $configKey ?>launch_class'>ReciteMe Options:</label>
                            </th>
                            <td>
                                <textarea name='<?= $configKey ?>additional_options' id='<?= $configKey ?>additional_options' class='regular-text' rows="4" /><?= $additionalOptions ?></textarea>
                                <p>Add any "Options" code provided to you by the ReciteMe team here.</p>
                                <p>JSON can be put in here which is loaded into the Toolbar options.</p>
                                <p><strong>If you are unsure, leave this empty.</strong></p>
                            </td>
                        </tr>
                        <tr>
                            <th scope='row'>
                                <label for='<?= $configKey ?>launch_class'>ReciteMe Loaded Code:</label>
                            </th>
                            <td>
                                <textarea name='<?= $configKey ?>loaded_code' id='<?= $configKey ?>loaded_code' class='regular-text' rows="4" /><?= $loadedCode ?></textarea>
                                <p>Add any "Loaded Code" provided to you by the ReciteMe team here.</p>
                                <p>Any Javascript added here will ran after the ReciteMe Toolbar opens.</p>
                                <p><strong>If you are unsure, leave this empty.</strong></p>
                            </td>
                        </tr>
                        <tr>
                            <th scope='row'>
                                <label for='<?= $configKey ?>launch_class'>ReciteMe Preload Code:</label>
                            </th>
                            <td>
                                <textarea name='<?= $configKey ?>preload_code' id='<?= $configKey ?>preload_code' class='regular-text' rows="4" /><?= $preloadCode ?></textarea>
                                <p>Add any "Preload Code" provided to you by the ReciteMe team here.</p>
                                <p>Any Javascript added here will ran immediately after the ReciteMe code is loaded (even if the Toolbar is closed).</p>
                                <p><strong>If you are unsure, leave this empty.</strong></p>
                            </td>
                        </tr>


                    <?php

                } //end else for tab selector...

    ?>
                </tbody>
            </table>
            <p class="submit">
                <input type="submit" class="button button-primary" value="Save Changes" />
            </p>
        </form>

    </div>

<?php
}


// Load ReciteMe Javascript int the Footer:
add_action('wp_footer', 'renderReciteScript');

/**
 * Renders ReciteMe Toolbar Javascript.
 */
function renderReciteScript()
{
    global $configKey;

    // Load Config Options:
    $reciteKey = get_option($configKey . "key");
    if (empty($reciteKey)) {
        return;
    }

    $reciteScriptDomain = "api.reciteme.com";
    $reciteRegion = get_option($configKey . "region");
    if ($reciteRegion == "au") {
        $reciteScriptDomain = "au-api.reciteme.com";
    }

    if ($reciteRegion == "us") {
        $reciteScriptDomain = "uswestapi.reciteme.com";
    }

    $autoLaunch = get_option($configKey . "launch_auto");
    $launchSelector = get_option($configKey . "launch_class");
    if (empty($launchSelector)) {
        $launchSelector = "[href$='#reciteme']";
    }
    $additionalOptionsJson = reciteGetCodeOption($configKey . "additional_options");
    $loadedCode = reciteGetCodeOption($configKey . "loaded_code");
    $preloadCode = reciteGetCodeOption($configKey . "preload_code");

    /* Floating Button */
    $floatingButton = get_option($configKey . "floating_button");

    /* Floating Button Position */
    $floatingButtonPosition = get_option($configKey . "floating_button_position");

    // Load Toolbar Options:
    $additionalOptions = json_decode($additionalOptionsJson, true);
    $options = is_array($additionalOptions) ? $additionalOptions : [];
    if (!isset($options['Tracker']['Ga']['enabled'])) {
        $options['Tracker']['Ga']['enabled'] = true;
    }
    if (!isset($options['Docreader']['endpoint'])) {
        $options['Docreader']['endpoint'] = 'https://docreader.reciteme.com/doc/url?q=';
    }
    $options['autoEnable'] = $autoLaunch ? 1 : 0;
    $position = get_option($configKey .'floating_button_position', 'bottom-right');
    $style = '';
    switch ($position) {
        case 'bottom-left':  $style = 'bottom:20px; left:20px;';
            break;
        case 'bottom-right': $style = 'bottom:20px; right:20px;';
            break;
        case 'middle-left':  $style = 'top:50%; left:20px; transform:translateY(-50%);';
            break;
        case 'middle-right': $style = 'top:50%; right:20px; transform:translateY(-50%);';
            break;
        case 'top-left':  $style = 'top:20px; left:20px;';
            break;
        case 'top-right': $style = 'top:20px; right:20px;';
            break;
    }

    ?>
    <script>
        var serviceUrl = "//<?= $reciteScriptDomain ?>/asset/js?key=";
        var serviceKey = <?= json_encode($reciteKey) ?>;
        var options = <?= json_encode($options) ?>;
        var autoLoad = <?= $autoLaunch ? "true" : "false" ?>;
        var floatingButton = <?= $floatingButton ? "true" : "false" ?>;
        var floatingButtonPosition = <?= json_encode($floatingButtonPosition) ?>;
        var enableFragment = "#reciteEnable";
        var reciteIsLoaded = [],
            frag = !1;
        var reciteMeButton;
        var buttonSrc = "<?= plugin_dir_url(__FILE__) . 'images/reciteme_button.png' ?>";
        var buttonSrcHover = "<?= plugin_dir_url(__FILE__) . 'images/reciteme_button_hover.png' ?>";
        window.location.hash === enableFragment && (frag = !0);

        function loadReciteScript(c, b) {
            var a = document.createElement("script");
            a.type = "text/javascript";
            a.readyState ? a.onreadystatechange = function() {
                if ("loaded" == a.readyState || "complete" == a.readyState){ 
                     a.onreadystatechange = null;
                     if(b !== undefined){ b(); }
                }
            } : void 0 != b && (a.onload = function() {
                b();
            });
            a.src = c;
            document.getElementsByTagName("head")[0].appendChild(a);
        }

        function _rc(c) {
            c += "=";
            for (var b = document.cookie.split(";"), a = 0; a < b.length; a++) {
                for (var d = b[a];
                    " " == d.charAt(0);) d = d.substring(1, d.length);
                if (0 == d.indexOf(c)) { return d.substring(c.length, d.length); } 
            }
            return null;
        }

        function loadReciteService(c) {
            for (var b = serviceUrl + serviceKey, a = 0; a < reciteIsLoaded.length; a++){
                if (reciteIsLoaded[a] == b) return;
            }
            reciteIsLoaded.push(b);
            loadReciteScript(serviceUrl + serviceKey, function() {
                "function" === typeof _reciteLoaded && _reciteLoaded();
                "function" == typeof c && c();
                Recite.load(options);
                Recite.Event.subscribe("Recite:load", function() {
                    Recite.enable();
                })
            })
        }

        function _createReciteButton() {
            var buttonParentSelector = 'body';
            var buttonContainer = document.createElement("a");
            buttonContainer.setAttribute('href', '#launchRecite');
            var buttonImage = document.createElement("img");
            var buttonAlt = "Recite Me accessibility and Language Support";
            var buttonTitle = "Launch Recite Me";

            buttonContainer.setAttribute('id', 'reciteme-button');
            buttonContainer.setAttribute('alt', buttonAlt);
            buttonContainer.setAttribute('title', buttonTitle);
            buttonContainer.setAttribute('role', 'button');
            buttonImage.setAttribute('alt', buttonAlt);
            buttonImage.setAttribute('title', buttonTitle);
            buttonImage.setAttribute('src', buttonSrc);
            buttonContainer.appendChild(buttonImage);
            var buttonParent = document.querySelector(buttonParentSelector);
            buttonParent.prepend(buttonContainer);
            buttonContainer.addEventListener("click", function(e) {
                e.preventDefault();
                loadReciteService();
                return false;
            });

            buttonContainer.addEventListener('mouseover', function() {
                buttonImage.setAttribute('src', buttonSrcHover);
            });

            buttonContainer.addEventListener('mouseout', function() {
                buttonImage.setAttribute('src', buttonSrc);
            });

            reciteMeButton = buttonContainer;

            // Add CSS styling
            var style = document.createElement('style');
            style.innerHTML = `
        #reciteme-button {
            /* Button Styling and Placement */
            background: #00344c;
            width: 100px;
            height: 100px;
            position: fixed;
            border-radius: 50%;
            z-index: 100;
            cursor: pointer;<?= $style ?>
        }
        #reciteme-button:hover {
            /* Hover Color */
            background: #e9322e;

        }
        #reciteme-button img {
            /** Button Image Size */
            width: 100px;
            height: 100px;
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
        }
    `;
            document.head.appendChild(style);
        }


        function loadReciteMe() {
            "true" == _rc("Recite.Persist") && loadReciteService();
            (autoLoad && "false" != _rc("Recite.Persist") || frag) && loadReciteService();

            var reciteMeButtons = document.querySelectorAll(<?= json_encode($launchSelector) ?>);
            for (var i = 0; i < reciteMeButtons.length; i++) {
                var reciteMeButton = reciteMeButtons[i];
                if (reciteMeButton) {
                    reciteMeButton.addEventListener("click", function() {
                        // Sync the toolbar with the translate button:
                        // we may need to store the page lang when recite is loaded
                        // so that we can restore it when we close ...
                        var storedLang = localStorage.getItem("user_lang");
                        if (storedLang != undefined) {
                            localStorage.setItem('launch_language', storedLang);
                        }
                        loadReciteService();
                    });
                }
            }
        }

        if (document.addEventListener) {
            document.addEventListener("DOMContentLoaded", function(event) {
                loadReciteMe();
            });
        } else {
            loadReciteMe();
        }

        <?= ($autoLaunch ? "loadReciteService();" : "") ?>
        <?= ($floatingButton ? "_createReciteButton();" : "") ?>

        function _reciteLoaded() {

            function _syncLanguage() {
                var lang = Recite.Preferences.get('language');
                var storedLang = localStorage.getItem("user_lang");
                if (lang != storedLang) {
                    localStorage.setItem("user_lang", lang);
                }
            }

            function _resetLang() {
                //we should set the stored lang back to what it was when recite loaded..
                var launchLang = localStorage.getItem('launch_language');
                if (launchLang != undefined) {
                    localStorage.setItem("user_lang", launchLang);
                } else {
                    localStorage.removeItem("user_lang");
                }
            }

            // Recite.Event.subscribe('Preferences:load', _syncLanguage);
            // Recite.Event.subscribe('Preferences:set', _syncLanguage);
            // Recite.Event.subscribe('Preferences:reset', _syncLanguage);
            // Recite.Event.subscribe('Controls:loaded', function () {
            //     Recite.Sizzle('[data-language="default"]')[0].addEventListener("click", function () {
            //         localStorage.removeItem("user_lang");
            //     });
            // });
            Recite.Event.subscribe('Recite:disable', _resetLang);
            if (document.getElementById("reciteme-button'")) {
                documentgetElementById("reciteme-button'").remove();
            };

            <?= $loadedCode ?>
        }

        <?= $preloadCode ?>


        // Translation Buttons:
        // Add translation to data-translate attributed element click events:
        var translateButtons = document.querySelectorAll("[data-translate]");
        for (var i = 0; i < translateButtons.length; i++) {
            translateButtons[i].addEventListener('click', function(e) {
                //update the non prefernces lang val here...
                var langCode = this.getAttribute("data-translate");
                if (langCode && langCode != undefined) {
                    // Do we want clicks on the in page lang selector
                    // that take place with recite open
                    // to be recalled 
                    // when recite closes?
                    // localStorage.setItem('launch_language' , langCode );
                    _handleTranslation(langCode);
                }

                e.preventDefault();
                e.stopPropagation();

                return false;
            }, false);
        }

        // Check for and handle stored language:
        if (_rc("Recite.Persist") === "false" || _rc("Recite.Persist") === null || _rc("Recite.Persist") == "null") {
            var storedLang = localStorage.getItem("user_lang");
            if (storedLang != "undefined") {
                _handleTranslation(storedLang);
            }
        }

        // Handle a translation:
        var reciteLoading = false;

        function _handleTranslation(lang) {
            if (lang === null || lang == "null" || lang == _getDocLang()){
                return;
            }

            if (typeof(Recite) != "undefined") {
                reciteLoading = false;
                localStorage.setItem("user_lang", lang);
                Recite.Language.Translate.translate(document.getElementsByTagName("body")[0], lang);
                if (Recite.isEnabled()) {
                    Recite.Preferences.set('language', lang);
                }
            } else {
                //check that we haven’t already requested this -
                if (!reciteLoading) {
                    loadAndTranslate(lang);
                }
            }
        }

        // Load ReciteMe core and schedule an initial translation:
        function loadAndTranslate(lang) {
            reciteLoading = true;
            loadReciteScript(serviceUrl + serviceKey, function() {
                _handleTranslation(lang); //this is in the script load callback so no ‘looping’
            });
        }

        // Assess the default language of the page:
        function _getDocLang() {
            var html = document.getElementsByTagName("html");
            if (html[0].hasAttribute("lang")) {
                return html[0].getAttribute("lang");
            }
            var body = document.getElementsByTagName("body");
            if (body[0].hasAttribute("lang")) {
                return body[0].getAttribute("lang");
            }
            return null;
        }
    </script>
<?php
}
add_action('admin_footer', function () {
    $screen = get_current_screen();
    // Ensure we're on the correct admin page (use the slug you registered)
    if ($screen && $screen->id === 'settings_page_reciteMeSettings') {
        renderAdminReciteScript();
    }
});
function renderAdminReciteScript()
{
    global $configKey;
    ?>
    <script>
            document.addEventListener('DOMContentLoaded', function () {

                const checkbox = document.getElementById('<?= $configKey ?>floating_button');
                const dropdownRow = document.getElementById('<?= $configKey ?>floating_button_position')?.closest('tr');

                function toggleDropdown() {
                    if (checkbox && dropdownRow) {
                        dropdownRow.style.display = checkbox.checked ? 'table-row' : 'none';
                    }
                }

                if (checkbox) {
                    checkbox.addEventListener('change', toggleDropdown);
                    toggleDropdown(); // Initial call on page load
                }
            });
        </script>
    <?php
}
